local assets =
{
    Asset("ANIM", "anim/roncatclover.zip"),
    Asset("ANIM", "anim/roncatclover_anim.zip"),
	Asset("ATLAS", "images/inventoryimages/roncatclover.xml"),
}
local function ondestroyed(inst, fueltaker)
	-- When this is perished, this uses inst. When taken as fuel, this uses fueltaker.
	if not fueltaker then
		fueltaker = inst
	end
	-- Cancel if there's a luck protector
	if FindLuckProtector(fueltaker) then
		return
	end
	local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
	if not owner then
		-- Target a nearby jinx
		owner = FindJinx(fueltaker)
	end
	if owner then
		-- Strike target taker instead of jinx
		local targettaker = FindTargetTaker(owner,10)
		if targettaker then
			owner = targettaker
		end
		-- Doing task in time to allow clover to despawn and thus not count as a lucky charm.
		local pos = Vector3(owner.Transform:GetWorldPosition())
		owner:DoTaskInTime(0, function()
			if IsJinxed(owner) and GetSeasonManager() then
				GetSeasonManager():DoLightningStrike(pos)
			end
		end)
	end
end
local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)
	if IsDLCEnabled(CAPY_DLC) then
		MakeInventoryFloatable(inst, "idle_water", "idle")
	end

    inst.AnimState:SetBank("roncatclover")
    inst.AnimState:SetBuild("roncatclover")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("cattoy")
	inst:AddTag("roncatluckycharm") -- Anyone will be protected when holding this

    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("tradable")

    inst:AddComponent("inspectable")

    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.TINY_FUEL
    inst.components.fuel:SetOnTakenFn(ondestroyed)

    MakeSmallBurnable(inst, TUNING.TINY_BURNTIME)
    MakeSmallPropagator(inst)
	if IsDLCEnabled(REIGN_OF_GIANTS) then
		inst.components.burnable:MakeDragonflyBait(3)
	end

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/roncatclover.xml"

    inst:AddComponent("edible")
    inst.components.edible.healthvalue = TUNING.HEALING_TINY
    inst.components.edible.hungervalue = 0
    inst.components.edible.sanityvalue = TUNING.SANITY_TINY	
	inst.components.edible.foodtype = "VEGGIE"

    inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_FAST)
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"
	inst.components.perishable:SetOnPerishFn(ondestroyed)

    inst:ListenForEvent("onignite", ondestroyed)

    return inst
end

return Prefab("common/inventory/roncatclover", fn, assets)